/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.misc;

import com.alc.moreminecarts.MMConstants;
import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MoreMinecartsMod;
import com.alc.moreminecarts.entities.HSMinecartEntities;
import com.alc.moreminecarts.entities.PistonPushcartEntity;
import com.alc.moreminecarts.items.CouplerItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="moreminecarts")
public class MoreMinecartsEventReciever {
    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity() instanceof PistonPushcartEntity) {
            MoreMinecartsMod.LOGGER.log(org.apache.logging.log4j.Level.WARN, "piston pushcart interact");
        }
        InteractionHand hand = event.getHand();
        Player player = event.getPlayer();
        ItemStack using = player.m_21120_(hand);
        InteractionHand other_hand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack using_secondary = player.m_21120_(other_hand);
        Entity entity = event.getTarget();
        if (using.m_41720_() == MMItemReferences.coupler || using_secondary.m_41720_() == MMItemReferences.coupler) {
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
            if (event.getWorld().m_5776_()) {
                return;
            }
            if (using.m_41720_() == MMItemReferences.coupler) {
                if (entity instanceof AbstractMinecart || entity instanceof Boat || entity instanceof Mob || entity instanceof EnderDragon) {
                    Level world = event.getWorld();
                    player.m_5496_(SoundEvents.f_11745_, 0.9f, 1.0f);
                    CouplerItem.hookIn(player, world, using, entity);
                } else {
                    CouplerItem.clearCoupler(using);
                }
            }
        }
        if (using.m_41720_() == MMItemReferences.high_speed_upgrade || using_secondary.m_41720_() == MMItemReferences.high_speed_upgrade) {
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
            if (event.getWorld().m_5776_()) {
                return;
            }
            if (using.m_41720_() == MMItemReferences.high_speed_upgrade && entity instanceof AbstractMinecart && !(entity instanceof HSMinecartEntities.IHSCart)) {
                boolean success = HSMinecartEntities.upgradeMinecart((AbstractMinecart)entity);
                if (!player.m_7500_() && success) {
                    using.m_41774_(1);
                }
            }
        }
        if ((event.getTarget() instanceof HSMinecartEntities.HSMinecart || event.getTarget() instanceof HSMinecartEntities.HSPushcart) && event.getTarget().f_19797_ < 10) {
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if ((Integer)MMConstants.CONFIG_GLASS_CACTUS_SPAWNS.get() == 0) {
            return;
        }
        if (event.getCategory() == Biome.BiomeCategory.DESERT || event.getCategory() == Biome.BiomeCategory.MESA) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, MoreMinecartsMod.GLASS_CACTUS_PLACER);
        }
    }
}

